<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowPRPage()
  ===================================================*/

  function ShowPRPage() {

    // vars global configuration
    global $dbConn, $theme_path, $theme_name, $num_rows, $max_rows;

    // vars url & form
    global $pr, $pg_which;

    // vars messages
    global $msg;

    // vars template
    global $link, $pagination;

    $tpl = new Template();

    // show links
    $links_obj = new clsLink;
    $links_obj->query = "
      select idx_link.*, 
             if (isnull(premium) || expire < now() || paid != 1, 0, premium) premium,
             if (isnull(sponsored) || expire < now() || paid != 1, 0, sponsored) sponsored
      from idx_link
           left join idx_paid_listing on (idx_link.link_id = idx_paid_listing.link_id)
           left join idx_pagerank on (idx_link.link_id = idx_pagerank.link_id)
		  where (rank = '$pr')";

    if ($_COOKIE['COOKIE_SORT_BY']) {
      $links_obj->query .= "	order by sponsored desc, premium desc, $_COOKIE[COOKIE_SORT_BY] $_COOKIE[COOKIE_SORT_ORDER]";
    }
    else {
      $links_obj->query .= "	order by sponsored desc, premium desc, bid desc";
    }

    $links_obj->table_name            = "idx_link";
    $links_obj->category_table_name   = "idx_category";
    $links_obj->user_table_name       = "idx_users";
    $links_obj->editor_table_name     = "idx_editor";
    $links_obj->template_file         = $theme_path . "rows.html";
    $links_obj->date_format           = $msg["10014"];
    $links_obj->rating_image_path     = "themes/" . $theme_name . "/images/rating/";
    $links_obj->rev_rating_image_path = "themes/" . $theme_name . "/images/review/";
    $links_obj->header                = $msg["10013"];
    $links_obj->paging                = true;
    $links_obj->pg_size               = $max_rows;
    $links_obj->href                  = "browsepr.php";
    $links_obj->more_param            = "&amp;pr=$pr";
    $link                             = $links_obj->Display();
    $num_rows                         = $links_obj->record_count_of_display + @count($lid);
    $pagination                       = $links_obj->pagination;

    DisplayTemplate($theme_path . "browsepr.html", "\$pr,\$num_rows,\$pagination,\$link,\$start_number");
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  AddFilter("page_cache");
  RunPreFilter(__FILE__);

  if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    RemoveFilter("page_cache");
    setcookie("COOKIE_SORT_BY", $_POST['sort_by'], 0, "/",  "", 0);
    setcookie("COOKIE_SORT_ORDER", $_POST['sort_order'], 0, "/",  "", 0);
    Redirect($_SERVER['REQUEST_URI']);
  }

  if (!defined('CACHED_PAGE')) {
    ShowPRPage();
  }

  RunPostFilter(__FILE__);

?>